﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;

namespace Advent.Controls
{
    public partial class AI7280SpecificExamples : UserControl
    {

        private AI7280_CO_Simulator _7280;


        public AI7280SpecificExamples()
        {
            InitializeComponent();
            freq_Start.Freq = Frequency.InHz(100);
            freq_Stop.Freq = Frequency.InHz(1100);
            txt_Points.Text = "10";
            txt_linger.Text = "200";
        }

        public void SetDevice(AI7280_CO_Simulator Device)
        {
            this._7280 = Device;

        }


        private void btn_FrequencySweep_Click(object sender, EventArgs e)
        {
            try
            {
                int points;
                double Linger;

                if (!double.TryParse(txt_linger.Text, out Linger)) throw new Exception("Invalid linger time");
                if (!int.TryParse(txt_Points.Text, out points) || (points <=0)) throw new Exception("Invalid number of points");


                // We call a generic frequency sweep algorithm which uses a generic emter interface which can be 
                // used for several different products!
                Advent.Sweeps.LinearFrequencySweep(_7280.ToneA, SignalLevel.InVrms(1),
                                                            _7280.Meter, freq_Start.Freq, freq_Stop.Freq, points, TimeInterval.InMilliseconds(Linger));
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            
        }

        private void btn_Send_CallerID_Ring_Click(object sender, EventArgs e)
        {
            try
            {
                Advent.COExamples.SendCallerIDAfterRing(_7280);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void btn_SendCASCallerID_Click(object sender, EventArgs e)
        {
            try
            {
                Advent.COExamples.Send_CAS_CallerID(_7280);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void btn_SendCIDBadXSum_Click(object sender, EventArgs e)
        {
            try
            {
                Advent.COExamples.Send_CallerID_With_Bad_Checksum(_7280);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void btn_CallerID_CustomEncoding_Click(object sender, EventArgs e)
        {
            try
            {
                Advent.COExamples.Send_CallerID_With_Stopbit_Stuffing(_7280);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void btn_SendCIDWithNoise_Click(object sender, EventArgs e)
        {
            try
            {
                Advent.COExamples.Send_CallerID_With_Noise(_7280);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }




    }
}
